/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.compat.IrisCompat;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.Rank;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.utils.CardImageUtils;
import dev.lucaargolo.charta.utils.ExpandedStreamCodec;
import dev.lucaargolo.charta.utils.SuitImage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1814;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class CardDeck {
    public static final CardDeck EMPTY = new CardDeck(class_1814.field_8906, false, List.of(), s -> Charta.MISSING_SUIT, s -> "suit.charta.unknown", c -> Charta.MISSING_CARD, c -> "card.charta.unknown", () -> Charta.MISSING_DECK, () -> "deck.charta.unknown");
    public static final class_9139<ByteBuf, CardDeck> STREAM_CODEC = ExpandedStreamCodec.composite(class_1814.field_50003, CardDeck::getRarity, class_9135.field_48547, CardDeck::isTradeable, class_9135.method_56376(ArrayList::new, Card.STREAM_CODEC), CardDeck::getCards, class_9135.method_56377(HashMap::new, Suit.STREAM_CODEC, (class_9139)class_2960.field_48267), CardDeck::getSuitsLocation, class_9135.method_56377(HashMap::new, Suit.STREAM_CODEC, (class_9139)class_9135.field_48554), CardDeck::getSuitsTranslatableKeys, class_9135.method_56377(HashMap::new, Card.STREAM_CODEC, (class_9139)class_2960.field_48267), CardDeck::getCardsLocation, class_9135.method_56377(HashMap::new, Card.STREAM_CODEC, (class_9139)class_9135.field_48554), CardDeck::getCardsTranslatableKeys, class_2960.field_48267, CardDeck::getDeckLocation, class_9135.field_48554, CardDeck::getDeckTranslatableKey, (x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8) -> new CardDeck((class_1814)x$0, (boolean)x$1, (List<Card>)((List)x$2), (Map<Suit, class_2960>)x$3, (Map<Suit, String>)x$4, (Map<Card, class_2960>)x$5, (Map<Card, String>)x$6, (class_2960)x$7, (String)x$8));
    public static final Codec<CardDeck> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1814.field_50001.fieldOf("rarity").forGetter(CardDeck::getRarity), (App)Codec.BOOL.fieldOf("tradeable").forGetter(CardDeck::isTradeable), (App)Card.CODEC.listOf().fieldOf("cards").forGetter(CardDeck::getCards), (App)Codec.simpleMap(Suit.CODEC, (Codec)class_2960.field_25139, (Keyable)class_3542.method_28142((class_3542[])Suit.values())).fieldOf("suits_images").forGetter(CardDeck::getSuitsLocation), (App)Codec.simpleMap(Suit.CODEC, (Codec)Codec.STRING, (Keyable)class_3542.method_28142((class_3542[])Suit.values())).fieldOf("suits_keys").forGetter(CardDeck::getSuitsTranslatableKeys), (App)Codec.simpleMap(Card.CODEC, (Codec)class_2960.field_25139, (Keyable)class_3542.method_28142((class_3542[])Card.values())).fieldOf("cards_images").forGetter(CardDeck::getCardsLocation), (App)Codec.simpleMap(Card.CODEC, (Codec)Codec.STRING, (Keyable)class_3542.method_28142((class_3542[])Suit.values())).fieldOf("cards_keys").forGetter(CardDeck::getCardsTranslatableKeys), (App)class_2960.field_25139.fieldOf("deck_image").forGetter(CardDeck::getDeckLocation), (App)Codec.STRING.fieldOf("deck_key").forGetter(CardDeck::getDeckTranslatableKey)).apply((Applicative)instance, CardDeck::new));
    private final class_1814 rarity;
    private final boolean tradeable;
    private final ImmutableList<Card> cards;
    private final Function<Suit, class_2960> suitsLocation;
    private final Function<Suit, String> suitsTranslatableKeys;
    private final Function<Card, class_2960> cardsLocation;
    private final Function<Card, String> cardsTranslatableKeys;
    private final Supplier<class_2960> deckLocation;
    private final Supplier<String> deckTranslatableKey;

    private CardDeck(class_1814 rarity, boolean tradeable, List<Card> cards, Map<Suit, class_2960> suitsLocation, Map<Suit, String> suitsTranslatableKey, Map<Card, class_2960> cardsLocation, Map<Card, String> cardsTranslatableKey, class_2960 deckLocation, String deckTranslatableKey) {
        this(rarity, tradeable, cards, (Suit suit) -> suitsLocation.getOrDefault(suit, Charta.MISSING_SUIT), (Suit suit) -> suitsTranslatableKey.getOrDefault(suit, "suit.charta.unknown"), (Card card) -> cardsLocation.getOrDefault(card, Charta.MISSING_CARD), (Card card) -> cardsTranslatableKey.getOrDefault(card, "card.charta.unknown"), () -> deckLocation, () -> deckTranslatableKey);
    }

    public CardDeck(class_1814 rarity, boolean tradeable, List<Card> cards, Function<Suit, class_2960> suitsLocation, Function<Suit, String> suitsTranslatableKey, Function<Card, class_2960> cardsLocation, Function<Card, String> cardsTranslatableKey, Supplier<class_2960> deckLocation, Supplier<String> deckTranslatableKey) {
        this.rarity = rarity;
        this.tradeable = tradeable;
        this.cards = ImmutableList.copyOf(cards);
        this.suitsLocation = suitsLocation;
        this.suitsTranslatableKeys = suitsTranslatableKey;
        this.cardsLocation = cardsLocation;
        this.cardsTranslatableKeys = cardsTranslatableKey;
        this.deckLocation = deckLocation;
        this.deckTranslatableKey = deckTranslatableKey;
    }

    public class_2561 getName() {
        return class_2561.method_43471((String)this.deckTranslatableKey.get());
    }

    public class_2960 getSuitTexture(Suit suit, boolean glow) {
        if (glow && IrisCompat.isPresent()) {
            return IrisCompat.getSuitGlowTexture(this.suitsLocation.apply(suit));
        }
        return ChartaClient.getSuitTexture(this.suitsLocation.apply(suit));
    }

    public String getSuitTranslatableKey(Suit suit) {
        return this.suitsTranslatableKeys.apply(suit);
    }

    public class_2960 getCardTexture(Card card, boolean glow) {
        if (glow && IrisCompat.isPresent()) {
            return IrisCompat.getCardGlowTexture(this.cardsLocation.apply(card));
        }
        return ChartaClient.getCardTexture(this.cardsLocation.apply(card));
    }

    public String getCardTranslatableKey(Card card) {
        return this.cardsTranslatableKeys.apply(card);
    }

    public class_2960 getDeckTexture(boolean glow) {
        if (glow && IrisCompat.isPresent()) {
            return IrisCompat.getDeckGlowTexture(this.deckLocation.get());
        }
        return ChartaClient.getDeckTexture(this.deckLocation.get());
    }

    public class_1814 getRarity() {
        return this.rarity;
    }

    public boolean isTradeable() {
        return this.tradeable;
    }

    public ImmutableList<Card> getCards() {
        return this.cards;
    }

    private Map<Suit, class_2960> getSuitsLocation() {
        return Maps.asMap(new TreeSet<Suit>(Arrays.asList(Suit.values())), this.suitsLocation::apply);
    }

    private Map<Suit, String> getSuitsTranslatableKeys() {
        return Maps.asMap(new TreeSet<Suit>(Arrays.asList(Suit.values())), this.suitsTranslatableKeys::apply);
    }

    private Map<Card, class_2960> getCardsLocation() {
        return Maps.asMap(new TreeSet<Card>(Arrays.asList(Card.values())), this.cardsLocation::apply);
    }

    private Map<Card, String> getCardsTranslatableKeys() {
        return Maps.asMap(new TreeSet<Card>(Arrays.asList(Card.values())), this.cardsTranslatableKeys::apply);
    }

    public class_2960 getDeckLocation() {
        return this.deckLocation.get();
    }

    public String getDeckTranslatableKey() {
        return this.deckTranslatableKey.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardDeck deck = (CardDeck)o;
        return this.rarity == deck.rarity && Objects.equals(this.cards, deck.cards) && Objects.equals(this.getSuitsLocation(), deck.getSuitsLocation()) && Objects.equals(this.getSuitsTranslatableKeys(), deck.getSuitsTranslatableKeys()) && Objects.equals(this.getCardsLocation(), deck.getCardsLocation()) && Objects.equals(this.getCardsTranslatableKeys(), deck.getCardsTranslatableKeys()) && Objects.equals(this.deckLocation.get(), deck.deckLocation.get()) && Objects.equals(this.deckTranslatableKey.get(), deck.deckTranslatableKey.get());
    }

    public int hashCode() {
        return Objects.hash(this.rarity, this.cards, this.getSuitsLocation(), this.getSuitsTranslatableKeys(), this.getCardsLocation(), this.getCardsTranslatableKeys(), this.deckLocation.get(), this.deckTranslatableKey.get());
    }

    public static CardDeck simple(class_1814 rarity, boolean canBeTraded, class_2960 cardLocation, class_2960 deckLocation) {
        return CardDeck.simple(rarity, canBeTraded, cardLocation, cardLocation, deckLocation);
    }

    public static CardDeck simple(class_1814 rarity, boolean canBeTraded, class_2960 suitLocation, class_2960 cardLocation, class_2960 deckLocation) {
        ArrayList<Card> deck = new ArrayList<Card>();
        for (Suit suit2 : Suit.values()) {
            if (suit2 == Suit.BLANK) continue;
            for (Rank rank : Rank.values()) {
                if (rank == Rank.BLANK || rank == Rank.JOKER) continue;
                deck.add(new Card(suit2, rank));
            }
        }
        String translatableKey = "deck." + deckLocation.method_12836() + "." + cardLocation.method_12832().replace("/", ".");
        if (!cardLocation.method_12832().equals(deckLocation.method_12832())) {
            translatableKey = "deck." + deckLocation.method_12836() + "." + deckLocation.method_12832().replace("/", ".");
        }
        String deckTranslatableKey = translatableKey;
        return new CardDeck(rarity, canBeTraded, deck, suit -> suitLocation.method_48331("/" + suit.ordinal()), suit -> "suit.charta." + (suit == Suit.BLANK ? "unknown" : suit.method_15434()), card -> cardLocation.method_48331("/" + card.getSuit().ordinal() + "_" + card.getRank().ordinal()), card -> card.getRank() == Rank.BLANK ? "suit.charta." + (card.getSuit() == Suit.BLANK ? "unknown" : card.getSuit().method_15434()) : "card.charta." + (String)(card.getSuit() == Suit.BLANK ? "unknown" : card.getSuit().method_15434() + "." + card.getRank().method_15434()), () -> deckLocation, () -> deckTranslatableKey);
    }

    public static CardDeck fun(class_1814 rarity, boolean canBeTraded, class_2960 cardLocation, class_2960 deckLocation) {
        return CardDeck.fun(rarity, canBeTraded, cardLocation, cardLocation, deckLocation);
    }

    public static CardDeck fun(class_1814 rarity, boolean canBeTraded, class_2960 suitLocation, class_2960 cardLocation, class_2960 deckLocation) {
        ArrayList<Card> deck = new ArrayList<Card>();
        for (Suit suit2 : Suit.values()) {
            if (suit2 == Suit.BLANK) continue;
            for (Rank rank : Rank.values()) {
                deck.add(new Card(suit2, rank));
                if (rank == Rank.BLANK || rank == Rank.JOKER || rank == Rank.TEN) continue;
                deck.add(new Card(suit2, rank));
            }
        }
        String translatableKey = "deck." + deckLocation.method_12836() + "." + cardLocation.method_12832().replace("/", ".");
        if (!cardLocation.method_12832().equals(deckLocation.method_12832())) {
            translatableKey = "deck." + deckLocation.method_12836() + "." + deckLocation.method_12832().replace("/", ".");
        }
        String deckTranslatableKey = translatableKey;
        return new CardDeck(rarity, canBeTraded, deck, suit -> suitLocation.method_48331("/" + suit.ordinal()), suit -> "suit.charta." + CardDeck.getFunSuit(suit), card -> cardLocation.method_48331("/" + card.getSuit().ordinal() + "_" + card.getRank().ordinal()), card -> "card.charta." + CardDeck.getFunCardKey(card), () -> deckLocation, () -> deckTranslatableKey);
    }

    private static String getFunSuit(Suit suit) {
        return switch (suit) {
            case Suit.SPADES -> "red";
            case Suit.HEARTS -> "yellow";
            case Suit.CLUBS -> "green";
            case Suit.DIAMONDS -> "blue";
            default -> "unknown";
        };
    }

    private static String getFunCardKey(Card card) {
        if (card.getSuit() == Suit.BLANK) {
            return "unknown";
        }
        String rank = switch (card.getRank()) {
            case Rank.BLANK -> "wild";
            case Rank.ACE -> "one";
            case Rank.TEN -> "zero";
            case Rank.JACK -> "block";
            case Rank.QUEEN -> "reverse";
            case Rank.KING -> "plus_two";
            case Rank.JOKER -> "wild_plus_four";
            default -> card.getRank().method_15434();
        };
        return switch (card.getRank()) {
            case Rank.BLANK, Rank.JOKER -> rank;
            default -> CardDeck.getFunSuit(card.getSuit()) + "." + rank;
        };
    }

    public int getCardColor(Card card) {
        return this.getSuitColor(card.getSuit());
    }

    public int getSuitColor(Suit suit) {
        SuitImage image = Charta.CARD_SUITS.getImages().getOrDefault(this.suitsLocation.apply(suit), CardImageUtils.EMPTY_SUIT);
        if (image == CardImageUtils.EMPTY_SUIT) {
            return 0xFFFFFF;
        }
        int color = image.getAverageColor();
        class_243 col = class_243.method_24457((int)color);
        double brightness = 0.299 * col.field_1352 + 0.587 * col.field_1351 + 0.114 * col.field_1350;
        if (brightness < 0.5) {
            double factor = 637.5;
            int r = Math.min(255, (int)(col.field_1352 * factor));
            int g = Math.min(255, (int)(col.field_1351 * factor));
            int b = Math.min(255, (int)(col.field_1350 * factor));
            return r << 16 | g << 8 | b;
        }
        return color;
    }
}

